Function CreateShortcut(pShortcutPath, pTargetPath) : 
	CreateShortcut = False : On Error Resume Next
	Dim objShell : Set objShell = WScript.CreateObject("WScript.Shell")
	Dim objShortcut : Set objShortcut = objShell.CreateShortcut(pShortcutPath)
	If Err.Number <> 0 Then
		LogEchoLine "Error " & Err.Number & ": " & Err.Description
		Err.Clear
	Else
		objShortcut.Description = "Shortcut to " & pTargetPath
		objShortcut.TargetPath = pTargetPath
	objShortcut.Save
	
	If Err.Number = 0 Then CreateShortcut = True 
	End If

	Set objShortcut = Nothing
	Set objShell = Nothing
End Function

Function CreateNodesShortcut(objNodeCollection, path) 
	CreateNodesShortcut = False

	If Not objNodeCollection Is Nothing Then 
		For i = 0 To objNodeCollection.Count - 1 Step 1
			Dim objNode
			Set objNode = objNodeCollection.item(i)
			if objNode.Type = 1 then
				Call CreateShortcut(path + objNode.Title + ".lnk", objNode.URL)
			Else
				Call CreateNodesShortcut(objNode.Children, path)
			End If
		Next
	End If
End Function


Dim objCA 
Set objCA = CreateObject("CyberArticle.CAAutomationApp")

Function LoadMacroString(stringName)
    Dim macroAppGUID
    macroAppGUID = "{85868504-1923-45c3-9ABD-3C03678278E9}"
    
    LoadMacroString = objCA.LoadMacroString(macroAppGUID, stringName)
End Function



Dim objWizCommonUI
Set objWizCommonUI = CreateObject("WizTools.WizCommonUI")

Dim path
path = objWizCommonUI.SelectDir("", LoadMacroString("PromptSelectDirToSaveShortcut"))

If Len(path) > 0 Then
    Dim selectedNodes 
    Set selectedNodes = objCA.SelectedNodes

    If Not selectedNodes Is Nothing Then 
	    Call CreateNodesShortcut(selectedNodes, path)
    End If 
End If

